'Poker Solitaire
option base 1
dim integer c, h, v, i, pn, update_hsf
dim integer data_num, num_cards, num_dealt, num_selected, initial
dim integer card_dealt(25), pnf(25), pscore, hs(100) 'place number filled (0 or 1)
dim integer dcx, dcy 'dealt card x and y pixel values
dim integer suit_count(4), rank_count(13) 'used for determining score
dim integer royal, straight_flush, flush, straight, full_house, four_kind
dim integer three_kind, two_pair, one_pair, pair_count, low_bound, high_bound
dim string rank$, suit$, card_array$(52), pa$(25) 'position array
dim string card_file$, high$, hsc$(100)

'play flac "Juice Newton - Queen of Hearts.flac"
open "High Scores.dat" for input as #1
for i = 1 to 100
  line input #1, hsc$(i) 'line input does not use integers, it only uses strings
next i
close #1
for i = 1 to 100
  hs(i) = val(hsc$(i))
next i
initial = 0
num_cards = 0
for i = 1 to 52
  card_array$(i) = ""
next i

again:
num_dealt = 0
num_selected = 0
pscore = 0
dcx = 820
dcy = 68
card_file$ = ""
update_hsf = 0
for i = 1 to 25
  card_dealt(i) = 0
  pnf(i) = 0
  pa$(i) = ""
next i
initialize_counts()

mode 9, 16
cls
color rgb(Green)
font 3 '16x24 pixels
print @(550, 0) "Poker Solitaire";
color rgb(Red)
print @(820, 0) "Score";

font 2 '12x20 pixels
color rgb(Orange)
print @(550,  40) "100 Royal Flush";
print @(550,  60) " 75 Straight Flush";
print @(550,  80) " 50 Four of a Kind";
print @(550, 100) " 25 Full House";
print @(550, 120) " 20 Flush";
print @(550, 140) " 15 Straight";
print @(550, 160) " 10 Three of a Kind";
print @(550, 180) "  5 Two Pair";
print @(550, 200) "  2 One Pair";

font 4 '10x16 pixels
color rgb(Cyan)
print @(550, 320) "Top Scores Top Scores Top Scores Top Scores";
for i = 1 to 25
  if i < 10 then
    high$ = "#" + str$(i) + "  " + str$(hs(i), 4)
  else
    high$ = "#" + str$(i) + " " + str$(hs(i), 4)
  endif  
  high$ = high$ + "   #" + str$(i + 25) + " " + str$(hs(25 + i), 4)
  high$ = high$ + "   #" + str$(i + 50) + " " + str$(hs(50 + i), 4)
  if i = 25 then
    high$ = high$ + "  #" + str$(i + 75) + " " + str$(hs(75 + i), 4) 
  else
    high$ = high$ + "   #" + str$(i + 75) + " " + str$(hs(75 + i), 4) 
  endif
  color rgb(Cyan)
  print @(550, i * 16 + 320) left$(high$, 4)
  color rgb(Yellow)
  print @(590, i * 16 + 320) mid$(high$, 5, 6)
  color rgb(Cyan)
  print @(650, i * 16 + 320) mid$(high$, 11, 5)
  color rgb(Yellow)
  print @(700, i * 16 + 320) mid$(high$, 16, 6)
  color rgb(Cyan)
  print @(760, i * 16 + 320) mid$(high$, 22, 5)
  color rgb(Yellow)
  print @(810, i * 16 + 320) mid$(high$, 27, 6)
  color rgb(Cyan)
  print @(870, i * 16 + 320) mid$(high$, 33, 5)
  color rgb(Yellow)
  print @(920, i * 16 + 320) mid$(high$, 38, 6)
next i

font 6 '32x50 pixels
color rgb(Grey)
c = 0
for v = 50 to 670 step 155
  for h = 33 to 453 step 105
    inc c
    if c < 10 then
      print @(h, v) str$(c);
    else
      print @(h - 17, v) str$(c);
    endif
  next h
next v

for v = 0 to 616 step 154
  for h = 0 to 420 step 105
    box h, v, 98, 150,, rgb(Green)
  next h
next v

if initial = 0 then
  do
    read data_num, rank$, suit$
    if data_num = 0 then
      inc num_cards, -1
      exit do
    endif
    inc num_cards    
    card_array$(num_cards) = rank$ + suit$
  loop
  initial = 1
endif

deal_card()
calculate_score()
ending()

sub deal_card
  do
    if num_dealt = 25 then exit do
    try_again:
    num_selected = int(rnd * 52 + 1)
    for i = 1 to num_dealt
      if num_selected = card_dealt(i) then goto try_again:
    next i
    inc num_dealt
    card_dealt(num_dealt) = num_selected
    dcx = 820 : dcy = 68
    load_card()    
    font 2
    color rgb(Green)
    ask_again:
    print @(820, 258) "      " 'Erase the user's input
    print @(820, 238) "Place number"
    print @(820, 258) "";: input pn
    if pn < 1 or pn > 25 then goto ask_again: 'Only 1 - 25 allowed
    if pnf(pn) = 1 then goto ask_again: 'Position already has a placed card
    dcx = 105 * ((pn - 1) mod 5) 
    dcy = 154 * fix((pn - 1) / 5)    
    load_card()      
    pa$(pn) = card_array$(num_selected) 
    pnf(pn) = 1 'The position has been filled with a card
    print @(820, 258) "      " 'erase the user's input
  loop
end sub

sub load_card
  card_file$ = "98x150 PNG Cards/" + card_array$(num_selected) + " 98x150.png"
  load png card_file$, dcx, dcy  
end sub

sub initialize_counts
  for i = 1 to 4
    suit_count(i) = 0
  next i
  for i = 1 to 13
    rank_count(i) = 0
  next i
  pair_count = 0
  royal = 0
  straight_flush = 0
  flush = 0
  straight = 0
  full_house = 0
  four_kind = 0
  three_kind = 0
  two_pair = 0
  one_pair = 0
end sub

sub inside_for
  if right$(pa$(i), 1) = "D" then inc suit_count(1)
  if right$(pa$(i), 1) = "C" then inc suit_count(2)
  if right$(pa$(i), 1) = "S" then inc suit_count(3)
  if right$(pa$(i), 1) = "H" then inc suit_count(4)
  if left$(pa$(i), 1) = "A" then inc rank_count(1)
  if left$(pa$(i), 1) = "2" then inc rank_count(2)
  if left$(pa$(i), 1) = "3" then inc rank_count(3)
  if left$(pa$(i), 1) = "4" then inc rank_count(4)
  if left$(pa$(i), 1) = "5" then inc rank_count(5)
  if left$(pa$(i), 1) = "6" then inc rank_count(6)
  if left$(pa$(i), 1) = "7" then inc rank_count(7)
  if left$(pa$(i), 1) = "8" then inc rank_count(8)
  if left$(pa$(i), 1) = "9" then inc rank_count(9)
  if left$(pa$(i), 2) = "10" then inc rank_count(10)
  if left$(pa$(i), 1) = "J" then inc rank_count(11)
  if left$(pa$(i), 1) = "Q" then inc rank_count(12)
  if left$(pa$(i), 1) = "K" then inc rank_count(13) 
end sub

sub calculate_score
  low_bound = 1 : high_bound = 5
  for h = 1 to 5 'the horizontal rows 
    initialize_counts()
    for i = low_bound to high_bound
      inside_for()
    next i 
    calc_part2()
    inc low_bound, 5
    inc high_bound, 5
  next h

  low_bound = 1 : high_bound = 21
  for v = 1 to 5 'the vertical columns
    initialize_counts()
    for i = low_bound to high_bound step 5
      inside_for()
    next i 
    calc_part2()
    inc low_bound
    inc high_bound
  next v
end sub

sub calc_part2
  if suit_count(1) = 5 or suit_count(2) = 5 or suit_count(3) = 5 or suit_count(4) = 5 then flush = 1
  if flush = 1 and rank_count(1) = 1 and rank_count(13) = 1 and rank_count(12) = 1 and rank_count(11) = 1 and rank_count(10) = 1 then royal = 1
  for i = 1 to 9
    if rank_count(i) = 1 and rank_count(i + 1) = 1 and rank_count(i + 2) = 1 and rank_count(i + 3) = 1 and rank_count(i + 4) = 1 then straight = 1  
  next i
  'special case straight with Ace high
  if rank_count(10) = 1 and rank_count(11) = 1 and rank_count(12) = 1 and rank_count(13) = 1 and rank_count(1) = 1 then straight = 1
  if flush = 1 and straight = 1 then straight_flush = 1
  for i = 1 to 13
    if rank_count(i) = 4 then four_kind = 1
    if rank_count(i) = 3 then three_kind = 1
    if rank_count(i) = 2 then
      one_pair = 1
      inc pair_count 
    endif
  next i    
  if three_kind = 1 and one_pair = 1 then full_house = 1
  if pair_count = 2 then two_pair = 1

  for i = 1 to 1 'dummy loop used so can exit the structure
    if royal = 1 then
      inc pscore, 100
      exit for
    endif
    if straight_flush = 1 then
      inc pscore, 75
      exit for
    endif
    if four_kind = 1 then
      inc pscore, 50
      exit for
    endif
    if full_house = 1 then
      inc pscore, 25
      exit for
    endif
    if flush = 1 then
      inc pscore, 20
      exit for
    endif
    if straight = 1 then 
      inc pscore, 15
      exit for
    endif
    if three_kind = 1 then
      inc pscore, 10
      exit for
    endif
    if two_pair = 1 then
      inc pscore, 5
      exit for
    endif
    if one_pair = 1 then 
      inc pscore, 2
      exit for
    endif
  next i
end sub

sub ending
  font 3
  color rgb(Yellow)
  print @(900, 0) pscore;
  font 2  
  for h = 1 to 100
    if pscore > hs(h) then
      for i = 100 to (h + 1) step -1
        hs(i) = hs(i - 1)
      next i
      hs(h) = pscore
      update_hsf = 1
      exit for
    endif 
  next h

  if update_hsf = 1 then
    open "High Scores.dat" for output as #1
    for i = 1 to 100
      print #1, hs(i)
    next i
    close #1
  end if
  print @(820, 238) "              ";
  print @(820, 238) "Play Again";
  print @(820, 258) "";: input a$
  if left$(lcase$(a$), 1) = "y" then
    goto again:
  else
    end
  endif  
end sub

data  1, "2", "D"
data  2, "3", "D"
data  3, "4", "D"
data  4, "5", "D"
data  5, "6", "D"
data  6, "7", "D"
data  7, "8", "D"
data  8, "9", "D"
data  9, "10", "D"
data 10, "J", "D"
data 11, "Q", "D"
data 12, "K", "D"
data 13, "A", "D" 
data 14, "2", "C"
data 15, "3", "C"
data 16, "4", "C"
data 17, "5", "C"
data 18, "6", "C"
data 19, "7", "C"
data 20, "8", "C"
data 21, "9", "C"
data 22, "10", "C"
data 23, "J", "C"
data 24, "Q", "C"
data 25, "K", "C"
data 26, "A", "C"
data 27, "2", "S"
data 28, "3", "S"
data 29, "4", "S"
data 30, "5", "S"
data 31, "6", "S"
data 32, "7", "S"
data 33, "8", "S"
data 34, "9", "S"
data 35, "10", "S"
data 36, "J", "S"
data 37, "Q", "S"
data 38, "K", "S"
data 39, "A", "S"
data 40, "2", "H"
data 41, "3", "H"
data 42, "4", "H"
data 43, "5", "H"
data 44, "6", "H"
data 45, "7", "H"
data 46, "8", "H"
data 47, "9", "H"
data 48, "10", "H"
data 49, "J", "H"
data 50, "Q", "H"
data 51, "K", "H"
data 52, "A", "H"
data  0, "0", "0"

